<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:cfg=".">
	<xsl:output method="text"/>
	<!--##############  PARAMETER  ####################-->
	<!-- BEGIN mandatory parameters, set by TrafoValidate -->
	<xsl:param name="Filename" select="'n/a'"/>
	<xsl:param name="IsFirst" select="'false'"/>
	<xsl:param name="IdentKey" select="'n/a'"/>
	<xsl:param name="TimeStamp" select="'2000-01-01 00:00:00'"/>
	<!-- default language is EN if not set with AddXSLTParam -->
	<xsl:param name="Lang" select="'EN'"/>
	<!--##############  VARIABLES  ####################-->
	<xsl:variable name="Language">
		<xsl:choose>
			<!-- additionally DE is supported and used for configs using DE -->
			<xsl:when test="/*/HEADER/@rpsLanguage = 'DE'">EN</xsl:when>
			<xsl:when test="/*/HEADER/@rpsLanguage = 'EN'">EN</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$Lang"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
	<xsl:variable name="INDENT6">
		<xsl:text>&#32;&#32;&#32;&#32;&#32;&#32;</xsl:text>
	</xsl:variable>
	<xsl:variable name="INDENT8">
		<xsl:text>&#32;&#32;&#32;&#32;&#32;&#32;&#32;&#32;</xsl:text>
	</xsl:variable>
	<xsl:variable name="INDENT10">
		<xsl:text>&#32;&#32;&#32;&#32;&#32;&#32;&#32;&#32;&#32;&#32;</xsl:text>
	</xsl:variable>
	<xsl:variable name="INDENT12">
		<xsl:text>&#32;&#32;&#32;&#32;&#32;&#32;&#32;&#32;&#32;&#32;&#32;&#32;</xsl:text>
	</xsl:variable>
	<xsl:variable name="NEWLINE">
		<xsl:text>&#13;&#10;</xsl:text>
	</xsl:variable>
	<!--##############  BEGIN Namspace cfg   ####################-->
	<cfg:Stylesheet mode="EXAMINE" version="$Revision: 1.2 $" versionscope='V2_FILES'/>
	<cfg:Description lang="DE">Zeige alle CRC-Werte</cfg:Description>
	<cfg:Description lang="EN">Display all CRC-values</cfg:Description>
	<!--##############  END Namspace cfg   ####################-->
	<!--##############  MAIN Template for any ROOT ####################-->
	<xsl:template match="/">
		<!-- the identkey is written in any case otherwise TrafoValidate assumes an error in the stylesheet -->
		<xsl:if test="$IsFirst = 'true'">
			<xsl:value-of select="$IdentKey"/>
		</xsl:if>
		<!-- IMPORTANT: only the known roots are considered -->
		<xsl:choose>
			<xsl:when test="/CONFIG_NETWORK">
				<xsl:apply-templates/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:text>-&gt; </xsl:text>
				<xsl:value-of select="$Filename"/>
				<xsl:text> is not a V2.0 config with CRCs.</xsl:text>
				<xsl:value-of select="$NEWLINE"/>
				<xsl:value-of select="$NEWLINE"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!-- ############ Our expected ROOTS ##################-->
	<xsl:template match="/CONFIG_NETWORK">
		<xsl:if test="/*/HEADER/filename != ''">
			<xsl:call-template name="WriteFileInfo"/>
			<xsl:choose>
				<!-- error testing -->
				<xsl:when test="name() = 'CONFIG_NETWORK'">
					<xsl:text>-&gt; netCRC= </xsl:text>
					<xsl:value-of select="//NODES/netCRC"/>
					<xsl:value-of select="$NEWLINE"/>
					<xsl:for-each select="//NODES/NODE">
						<xsl:value-of select="$INDENT6"/>
						<xsl:text>-&gt; NODE</xsl:text>
						<xsl:value-of select="netGroup"/>
						<xsl:text>.</xsl:text>
						<xsl:value-of select="netNode"/>
						<xsl:value-of select="$NEWLINE"/>
						<xsl:value-of select="$INDENT8"/>
						<xsl:text>-&gt; netLocalCRC= </xsl:text>
						<xsl:value-of select="netLocalCRC"/>
						<xsl:value-of select="$NEWLINE"/>
						<xsl:value-of select="$INDENT10"/>
						<xsl:text>-&gt; EXPORTS/netCRC= </xsl:text>
						<xsl:value-of select="EXPORTS/netCRC"/>
						<xsl:value-of select="$NEWLINE"/>
						<xsl:value-of select="$INDENT10"/>
						<xsl:text>-&gt; IMPORTS/netCRC= </xsl:text>
						<xsl:value-of select="IMPORTS/netCRC"/>
						<xsl:value-of select="$NEWLINE"/>
						<xsl:value-of select="$INDENT10"/>
						<xsl:text>-&gt; CONFIG_INFO/xmlCRC= </xsl:text>
						<xsl:value-of select="descendant::xmlCRC"/>
						<xsl:value-of select="$NEWLINE"/>
						<xsl:value-of select="$INDENT12"/>
						<xsl:text>-&gt; CONFIG_INFO/guid= </xsl:text>
						<xsl:value-of select="descendant::guid"/>
						<xsl:value-of select="$NEWLINE"/>
						<xsl:value-of select="$INDENT12"/>
						<xsl:text>-&gt; CONFIG_INFO/rpsTimeStamp= </xsl:text>
						<xsl:value-of select="descendant::rpsTimeStamp"/>
						<xsl:value-of select="$NEWLINE"/>
					</xsl:for-each>
				</xsl:when>
				<xsl:otherwise>
        </xsl:otherwise>
			</xsl:choose>
		</xsl:if>
	</xsl:template>
	<!-- ######### -->
	<xsl:template name="WriteFileInfo">
		<xsl:text>-&gt; </xsl:text>
		<xsl:value-of select="substring-before(/*/HEADER/filename,'.xml')"/>
		<xsl:text>  ( revNumber= </xsl:text>
		<xsl:value-of select="/*/HEADER/revNumber"/>
		<xsl:text>, </xsl:text>
		<xsl:value-of select="/*/HEADER/lastModified"/>
		<xsl:text>, </xsl:text>
		<xsl:value-of select="$Filename"/>
		<xsl:text>)</xsl:text>
		<xsl:value-of select="$NEWLINE"/>
	</xsl:template>
	<!-- ######### -->
</xsl:stylesheet>
